import numpy as np
import matplotlib.pyplot as plt

def parse_channel_txt(file_path):
    with open(file_path, 'r') as f:
        lines = f.readlines()
    
    # The first line contains headers
    headers = lines[0].split()
    # Remaining lines are data
    data = []
    for line in lines[1:]:
        # Split by whitespace and convert to int, ignore empty lines
        row = [int(x) for x in line.split() if x.strip()]
        if row:  # Only add non-empty rows
            data.append(row)
    
    # Convert to numpy array (optional, for easy math)
    data = np.array(data)
    return headers, data


if __name__ == '__main__':

	headers, data = parse_channel_txt('t3histout.txt')

	print("Headers:", headers)

	data_T = data.T

	for idx, channel_data in enumerate(data_T):
	    plt.semilogy(channel_data, label=headers[idx])  # ',' as positional, not keyword

	plt.xlabel('Bin')
	plt.ylabel('Counts')
	plt.title('Channels')
	plt.legend()
	plt.show()