# Setup
The following part describes to do the basic setup of your first rust project using the HydraHarp 500. If you are not familiar with rust, it is highly recommended
to read the **rust book** https://doc.rust-lang.org/book/ as well as getting started with cargo, the rust package manager https://doc.rust-lang.org/cargo/

## Rust Version
This Code is build and tested with 
 - rustc 1.87.0 (17067e9ac 2025-05-09)
 - cargo 1.87.0 (99624be96 2025-05-06)

## Structure
root
├──src
│   ├── hh500.rs         # wrapper to convert C Api to rust
│   └── errorcodes.rs    # Definition of error codes that will be returned by every function in case of malfunction
├──examples
│   ├── histomode.rs     # A basic demonstration of working with the onboard histogrammer of the HH500 in Rust
│   └── tttrmode.rs      # A basic demonstration of performing a TTTR measurement using the HH500 in Rust
│
├── build.rs             # Build script, necessary for linking etc.  
├── Cargo.toml           # describe your dependencies here, like adding the package with version bytemuck = "1.7.0"
└── Cargo.lock           # DO NOT EDIT, contains exact information about dependencies. It is maintained by Cargo only!


## Library Installation
In order to use this demo please make sure the Hydraharp 500 library is installed. Follow the instructions described in the library manuals for Linux or Windows, respectively.


## Build
To build the rust code use the following command
'''
cargo build --examples
'''


## Run
To run one of the examples (eg. tttrmode.rs), use the following command
'''
cargo run --example tttrmode
'''

For more information, please visit https://doc.rust-lang.org/cargo/

# Debug and development
For debugging and future development we recommend the IDE Visual Studio code + the rust-analyzer extension