use std::convert::TryFrom;

#[derive(Debug, PartialEq, Eq)]
pub enum ErrorCode {
    None,
    DeviceOpenFail,
    DeviceBusy,
    DeviceHeventFail,
    DeviceCallbsetFail,
    DeviceBarmapFail,
    DeviceCloseFail,
    DeviceResetFail,
    DeviceGetversionFail,
    DeviceVersionMismatch,
    DeviceNotOpen,
    DeviceLocked,
    DeviceDriververMismatch,
    InstanceRunning,
    InvalidArgument,
    InvalidMode,
    InvalidOption,
    InvalidMemory,
    InvalidRdata,
    NotInitialized,
    NotCalibrated,
    DmaFail,
    XtdeviceFail,
    FpgaconfFail,
    IfconfFail,
    FiforesetFail,
    ThreadstateFail,
    ThreadlockFail,
    UsbGetdriververFail,
    UsbDriververMismatch,
    UsbGetifinfoFail,
    UsbHispeedFail,
    UsbVcmdFail,
    UsbBulkrdFail,
    UsbResetFail,
    LaneupTimeout,
    DoneallTimeout,
    MbAckTimeout,
    MactiveTimeout,
    MemclearFail,
    MemtestFail,
    CalibFail,
    RefselFail,
    StatusFail,
    ModnumFail,
    DigmuxFail,
    ModmuxFail,
    ModfwpcbMismatch,
    ModfwverMismatch,
    ModpropertyMismatch,
    InvalidMagic,
    InvalidLength,
    RateFail,
    ModfwverTooLow,
    ModfwverTooHigh,
    MbAckFail,
    InvalidData,
    EepromF01,
    EepromF02,
    EepromF03,
    EepromF04,
    EepromF05,
    EepromF06,
    EepromF07,
    EepromF08,
    EepromF09,
    EepromF10,
    EepromF11,
    EepromF12,
    EepromF13,
    EepromF14,
    EepromF15,
    UnsupportedFunction,
    WrongTrgmode,
    BulkrdinitFail,
    CreatethreadFail,
    FileopenFail,
    FilewriteFail,
    FilereadFail,
    SfpBusy,
    InvalidArgument1,
    InvalidArgument2,
    InvalidArgument3,
    InvalidArgument4,
    InvalidArgument5,
    InvalidArgument6,
    InvalidArgument7,
    InvalidArgument8,
    InvalidArgument9
}

impl TryFrom<i32> for ErrorCode {
    type Error = ();

    fn try_from(value: i32) -> Result<Self, Self::Error> {
        match value {    
            0 => Ok(ErrorCode::None),

            -1 => Ok(ErrorCode::DeviceOpenFail),
            -2 => Ok(ErrorCode::DeviceBusy),
            -3 => Ok(ErrorCode::DeviceHeventFail),
            -4 => Ok(ErrorCode::DeviceCallbsetFail),
            -5 => Ok(ErrorCode::DeviceBarmapFail),
            -6 => Ok(ErrorCode::DeviceCloseFail),
            -7 => Ok(ErrorCode::DeviceResetFail),
            -8 => Ok(ErrorCode::DeviceGetversionFail),
            -9 => Ok(ErrorCode::DeviceVersionMismatch),
            -10 => Ok(ErrorCode::DeviceNotOpen),
            -11 => Ok(ErrorCode::DeviceLocked),
            -12 => Ok(ErrorCode::DeviceDriververMismatch),

            -16 => Ok(ErrorCode::InstanceRunning),
            -17 => Ok(ErrorCode::InvalidArgument),
            -18 => Ok(ErrorCode::InvalidMode),
            -19 => Ok(ErrorCode::InvalidOption),
            -20 => Ok(ErrorCode::InvalidMemory),
            -21 => Ok(ErrorCode::InvalidRdata),
            -22 => Ok(ErrorCode::NotInitialized),
            -23 => Ok(ErrorCode::NotCalibrated),
            -24 => Ok(ErrorCode::DmaFail),
            -25 => Ok(ErrorCode::XtdeviceFail),
            -26 => Ok(ErrorCode::FpgaconfFail),
            -27 => Ok(ErrorCode::IfconfFail),
            -28 => Ok(ErrorCode::FiforesetFail),
            -29 => Ok(ErrorCode::ThreadstateFail),
            -30 => Ok(ErrorCode::ThreadlockFail),

            -32 => Ok(ErrorCode::UsbGetdriververFail),
            -33 => Ok(ErrorCode::UsbDriververMismatch),
            -34 => Ok(ErrorCode::UsbGetifinfoFail),
            -35 => Ok(ErrorCode::UsbHispeedFail),
            -36 => Ok(ErrorCode::UsbVcmdFail),
            -37 => Ok(ErrorCode::UsbBulkrdFail),
            -38 => Ok(ErrorCode::UsbResetFail),

            -40 => Ok(ErrorCode::LaneupTimeout),
            -41 => Ok(ErrorCode::DoneallTimeout),
            -42 => Ok(ErrorCode::MbAckTimeout),
            -43 => Ok(ErrorCode::MactiveTimeout),
            -44 => Ok(ErrorCode::MemclearFail),
            -45 => Ok(ErrorCode::MemtestFail),
            -46 => Ok(ErrorCode::CalibFail),
            -47 => Ok(ErrorCode::RefselFail),
            -48 => Ok(ErrorCode::StatusFail),
            -49 => Ok(ErrorCode::ModnumFail),
            -50 => Ok(ErrorCode::DigmuxFail),
            -51 => Ok(ErrorCode::ModmuxFail),
            -52 => Ok(ErrorCode::ModfwpcbMismatch),
            -53 => Ok(ErrorCode::ModfwverMismatch),
            -54 => Ok(ErrorCode::ModpropertyMismatch),
            -55 => Ok(ErrorCode::InvalidMagic),
            -56 => Ok(ErrorCode::InvalidLength),
            -57 => Ok(ErrorCode::RateFail),
            -58 => Ok(ErrorCode::ModfwverTooLow),
            -59 => Ok(ErrorCode::ModfwverTooHigh),
            -60 => Ok(ErrorCode::MbAckFail),
            -61 => Ok(ErrorCode::InvalidData),

            -64 => Ok(ErrorCode::EepromF01),
            -65 => Ok(ErrorCode::EepromF02),
            -66 => Ok(ErrorCode::EepromF03),
            -67 => Ok(ErrorCode::EepromF04),
            -68 => Ok(ErrorCode::EepromF05),
            -69 => Ok(ErrorCode::EepromF06),
            -70 => Ok(ErrorCode::EepromF07),
            -71 => Ok(ErrorCode::EepromF08),
            -72 => Ok(ErrorCode::EepromF09),
            -73 => Ok(ErrorCode::EepromF10),
            -74 => Ok(ErrorCode::EepromF11),
            -75 => Ok(ErrorCode::EepromF12),
            -76 => Ok(ErrorCode::EepromF13),
            -77 => Ok(ErrorCode::EepromF14),
            -78 => Ok(ErrorCode::EepromF15),

            -80 => Ok(ErrorCode::UnsupportedFunction),
            -81 => Ok(ErrorCode::WrongTrgmode),
            -82 => Ok(ErrorCode::BulkrdinitFail),
            -83 => Ok(ErrorCode::CreatethreadFail),
            -84 => Ok(ErrorCode::FileopenFail),
            -85 => Ok(ErrorCode::FilewriteFail),
            -86 => Ok(ErrorCode::FilereadFail),

            -90 => Ok(ErrorCode::SfpBusy),

            -201 => Ok(ErrorCode::InvalidArgument1),
            -202 => Ok(ErrorCode::InvalidArgument2),
            -203 => Ok(ErrorCode::InvalidArgument3),
            -204 => Ok(ErrorCode::InvalidArgument4),
            -205 => Ok(ErrorCode::InvalidArgument5),
            -206 => Ok(ErrorCode::InvalidArgument6),
            -207 => Ok(ErrorCode::InvalidArgument7),
            -208 => Ok(ErrorCode::InvalidArgument8),
            -209 => Ok(ErrorCode::InvalidArgument9),

            _ => Err(()),
        }
    }
}

// #[cfg(test)]
// mod tests {
//     use super::*;

//     #[test]
//     fn it_works() {
//         assert!(true)
//     }
//     #[test]
//     fn convert_42() {
//         assert_eq!(ErrorCode::MbAckTimeout, ErrorCode::try_from(-42).unwrap());
//     }
// }
