
/*
    HH500Lib programming library for HydraHarp 500
    PicoQuant GmbH

    Ver. 1.0.0.0     August 2025
*/


extern int HH500_GetLibraryVersion(char* vers);
extern int HH500_GetErrorString(char* errstring, int errcode);

extern int HH500_OpenDevice(int devidx, char* serial);
extern int HH500_CloseDevice(int devidx);
extern int HH500_Initialize(int devidx, int mode, int refsource);

//all functions below can only be used after HH500_Initialize

extern int HH500_GetHardwareInfo(int devidx, char* model, char* partno, char* version);
extern int HH500_GetSerialNumber(int devidx, char* serial);
extern int HH500_GetFeatures(int devidx, int* features);
extern int HH500_GetBaseResolution(int devidx, double* resolution, int* binsteps);
extern int HH500_GetNumOfInputChannels(int devidx, int* nchannels);

extern int HH500_GetSyncFeatures(int devidx, unsigned* features);
extern int HH500_SetSyncDiv(int devidx, int div);
extern int HH500_SetSyncTrgMode(int devidx, int mode);
extern int HH500_SetSyncEdgeTrg(int devidx, int level, int edge);
extern int HH500_SetSyncCFD(int devidx, int level, int zerocross);
extern int HH500_SetSyncChannelOffset(int devidx, int value);
extern int HH500_SetSyncChannelEnable(int devidx, int enable);
extern int HH500_SetSyncDeadTime(int devidx, int on, int deadtime);

extern int HH500_GetInputFeatures(int devidx, int channel, unsigned* features);
extern int HH500_SetInputTrgMode(int devidx, int channel, int mode);
extern int HH500_SetInputEdgeTrg(int devidx, int channel, int level, int edge);
extern int HH500_SetInputCFD(int devidx, int channel, int level, int zerocross);
extern int HH500_SetInputChannelOffset(int devidx, int channel, int value);
extern int HH500_SetInputDeadTime(int devidx, int channel, int on, int deadtime);
extern int HH500_SetInputHysteresis(int devidx, int hystcode);
extern int HH500_SetInputChannelEnable(int devidx, int channel, int enable);

extern int HH500_SetStopOverflow(int devidx, int stop_ovfl, unsigned int stopcount);
extern int HH500_SetBinning(int devidx, int binning);
extern int HH500_SetOffset(int devidx, int offset);
extern int HH500_SetHistoLen(int devidx, int lencode, int* actuallen);
extern int HH500_SetMeasControl(int devidx, int control, int startedge, int stopedge);
extern int HH500_SetTriggerOutput(int devidx, int period);
extern int HH500_SetLEDBrightness(int devidx, int brightness);

extern int HH500_ClearHistMem(int devidx);
extern int HH500_StartMeas(int devidx, int tacq);
extern int HH500_StopMeas(int devidx);
extern int HH500_CTCStatus(int devidx, int* ctcstatus);

extern int HH500_GetHistogram(int devidx, unsigned int *chcount, int channel);
extern int HH500_GetAllHistograms(int devidx, unsigned int *chcount);
extern int HH500_GetResolution(int devidx, double* resolution);
extern int HH500_GetSyncPeriod(int devidx, double* period);
extern int HH500_GetSyncRate(int devidx, int* syncrate);
extern int HH500_GetCountRate(int devidx, int channel, int* cntrate);
extern int HH500_GetAllCountRates(int devidx, int* syncrate, int* cntrates);
extern int HH500_GetFlags(int devidx, int* flags);
extern int HH500_GetElapsedMeasTime(int devidx, double* elapsed);
extern int HH500_GetStartTime(int devidx, unsigned int* timedw2, unsigned int* timedw1, unsigned int* timedw0);

extern int HH500_GetWarnings(int devidx, int* warnings);
extern int HH500_GetWarningsText(int devidx, char* text, int warnings);

//for the time tagging modes only
extern int HH500_SetOflCompression(int devidx, int holdtime);
extern int HH500_SetMarkerHoldoffTime(int devidx, int holdofftime);
extern int HH500_SetMarkerEdges(int devidx, int me1, int me2, int me3, int me4);
extern int HH500_SetMarkerEnable(int devidx, int en1, int en2, int en3, int en4);
extern int HH500_ReadFiFo(int devidx, unsigned int* buffer, int* nactual);

//for event filtering, time tagging modes only
extern int HH500_SetGroupEventFilter(int devidx, int groupidx, int timerange, int matchcnt, int inverse, int usechannels, int passchannels);
extern int HH500_EnableGroupEventFilter(int devidx, int groupidx, int enable);
extern int HH500_SetMainEventFilterParams(int devidx, int timerange, int matchcnt, int inverse);
extern int HH500_SetMainEventFilterChannels(int devidx, int blockidx, int usechannels, int passchannels);
extern int HH500_EnableMainEventFilter(int devidx, int enable);
extern int HH500_SetFilterTestMode(int devidx, int testmode);
extern int HH500_GetGroupFilteredRates(int devidx, int* syncrate, int* cntrates);
extern int HH500_GetMainFilteredRates(int devidx, int* syncrate, int* cntrates);

//for debugging only
extern int HH500_GetDebugInfo(int devidx, char *debuginfo);
extern int HH500_GetNumOfModules(int devidx, int* nummod);
extern int HH500_GetModuleInfo(int devidx, int modidx, int* modelcode, int* versioncode);
extern int HH500_SaveDebugDump(int devidx, char* filepath);

//for White Rabbit only
extern int HH500_WRabbitGetMAC(int devidx, unsigned char* mac_addr);
extern int HH500_WRabbitSetMAC(int devidx, unsigned char* mac_addr);
extern int HH500_WRabbitGetInitScript(int devidx, char* initscript);
extern int HH500_WRabbitSetInitScript(int devidx, char* initscript);
extern int HH500_WRabbitGetSFPData(int devidx, char* sfpnames, int* dTxs, int* dRxs, int* alphas);
extern int HH500_WRabbitSetSFPData(int devidx, char* sfpnames, int* dTxs, int* dRxs, int* alphas);
extern int HH500_WRabbitInitLink(int devidx, int link_on);
extern int HH500_WRabbitSetMode(int devidx, int bootfromscript, int reinit_with_mode, int mode);
extern int HH500_WRabbitSetTime(int devidx, unsigned int timehidw, unsigned int timelodw);
extern int HH500_WRabbitGetTime(int devidx, unsigned int* timehidw, unsigned int* timelodw, unsigned int* subsec16ns);
extern int HH500_WRabbitGetStatus(int devidx, int* wrstatus);
extern int HH500_WRabbitGetTermOutput(int devidx, char* buffer, int* nchar);

//for external FPGA interface only
extern int HH500_ExtFPGAInitLink(int devidx, int linknumber, int on);
extern int HH500_ExtFPGAGetLinkStatus(int devidx, int linknumber, unsigned int* status);
extern int HH500_ExtFPGASetMode(int devidx, int mode, int loopback);
extern int HH500_ExtFPGAResetStreamFifos(int devidx);
extern int HH500_ExtFPGAUserCommand(int devidx, int write, unsigned int addr, unsigned int* data);

//for Continuous Historamming Mode only
extern int HH500_GetContModeBlock(int devidx, void* blockbuffer, int* nbytesreceived);
extern int HH500_DissectContModeBlkHdr(
	void* blockbuffer,              //IN  buffer with raw continuous mode data block to dissect	
	unsigned int* blocknum,         //OUT counting up from 1, can be used for sanity check
	unsigned int* histlen,          //OUT number of histogram bins as set by HH500_SetHistoLen
	unsigned int* nhistograms,      //OUT number of histograms in this block (= num of active input channels)
	unsigned int* histchans,        //OUT array[MAXINPCHAN] indicating the corresponding input channels 
	unsigned int* flags,            //OUT bit0: stop on overflow occurred, bit1: contmode_mem full
	unsigned long long* starttime,  //OUT start time of this block of histograms in nanosec
	unsigned long long* duration,   //OUT histogram duration in nanosec
	unsigned int* markercounts);    //OUT array[4], count of occurrences of markers 0..3 within this time
extern int HH500_ExtractContModeBlkData(
	void* blockbuffer,              //IN buffer with raw continuous mode data block to extract from	
	unsigned int histindex,         //IN index of histogram to extract, must not exceed nhistograms-1 from block header
	unsigned int* channel,          //OUT input channel this histogram came from
	unsigned long long* histosum,   //OUT sum of counts in this histogram
	unsigned int* histogram);       //OUT histogram as array[histlen] with histlen from header

