OUTPUT_FORMAT("elf32-lm32")
ENTRY(_start)
MEMORY
{
    ram :
 ORIGIN = 0x00000000,
 LENGTH = 131072 - 2048
    stack :
 ORIGIN = 131072 - 2048,
 LENGTH = 2048
}
SECTIONS
{
 .boot : { *(.boot) } > ram
 .text : { *(.text .text.*) } > ram =0
 .rodata : { *(.rodata .rodata.*) } > ram
 .data : {
  *(.data .data.*)
  *(.stats)
 } > ram
 .bss : {
  _fbss = .;
  *(.bss .bss.*)
  *(COMMON)
  _ebss = .;
 } > ram
 PROVIDE(_endram = ORIGIN(stack));
 PROVIDE(_fstack = ORIGIN(stack) + LENGTH(stack) - 4);
 PROVIDE(fifo_log = 0);
 PROVIDE(_binary_rules_vlan_bin_start = 0);
 PROVIDE(_binary_rules_vlan_bin_end = 0);
}
