import numpy as np
import matplotlib.pyplot as plt

def parse_file(path):
    with open(path, "r") as f:
        filedata = f.read()
    x = filedata.replace('CH 0 ', '').split('\n')[:-1]
    return np.array(list(map(int, x[:-1])))


if __name__ == '__main__':
    path_master = "x64/Debug/wr_master/wr_master_dec.txt"
    path_slave = "x64/Debug/wr_slave/wr_slave_dec.txt"
    data_master = parse_file(path_master)
    data_slave = parse_file(path_slave)

    time_diff = data_master-data_slave
    print(f'C2Crms = {np.std(time_diff)}, CHMrms = {np.std(np.diff(data_master))}, CHSrms = {np.std(np.diff(data_slave))}')
    plt.plot(time_diff)
    plt.show()