# Setup
The following part describes to do the basic setup of your first rust project using the Multiharp. If you are not familiar with rust, it is highly recommended
to read the **rust book** https://doc.rust-lang.org/book/ as well as getting started with cargo, the rust package manager https://doc.rust-lang.org/cargo/


## Structure
root
├──src
│   ├── main.rs          # A very basic demonstration on how to use the Multiharp with Rust
│   ├── MH.rs            # wrapper to convert C to rust
│   └── errorcodes.rs    # Definition of error codes that will be returned by every function in case of malfunction
│
├── build.rs             # Build script, necessary for linking etc.  
├── Cargo.toml           # describe your dependencies here, like adding the package with version bytemuck = "1.7.0"
└── Cargo.lock           # DO NOT EDIT, contains exact information about dependencies. It is maintained by Cargo only!

## Environment
To make the Multiharp library path visible to the linker, you have to adapt the search path using the following command based on your OS

### linux
If you want to install the library follow the instructions for linux describes in the manual.
'''
export LD_LIBRARY_PATH=.:$LD_LIBRARY_PATH
'''

### windows
'''
set PATH=%CD%;%PATH%
'''

## Build
To build the rust code use the following command
'''
cargo build
'''


## Run
To run the compiled code use the following command
'''
cargo run
'''

For more information, please visit https://doc.rust-lang.org/cargo/

# Debug and development
For debugging and future development we recommend the IDE Visual Studio code + the rust-analyzer extension