import numpy as np
import matplotlib.pyplot as plt
import struct


def read_binary(filepath):
    with open(filepath, "rb") as file:
        data = file.read()
    return bytes_to_32bit_array(data)

def is_special(t2):
    return 0 != (t2 & 1<<31)

def get_channel(t2):
    return (t2 >> 25) & 0x3F

def get_time_tag(t2):
    return t2 & 0x1FFFFFF

def is_overflow(t2):
    return get_channel(t2) == 0x3F

def bytes_to_32bit_array(byte_array):
    num_of_integers = len(byte_array) // 4
    format_string = f"<{num_of_integers}I"
    int_array = struct.unpack(format_string, byte_array)
    return int_array

def parse_t2_file(data):
    T2WRAPAROUND_V2 = 33554432
    overflow_correction = 0
    time_data = []
    for idx, d in enumerate(data):
        t = 0
        if is_special(d):
            if is_overflow(d):
                overflow_correction += T2WRAPAROUND_V2 * get_time_tag(d)
            else:
                if 0 == get_channel(d):
                    t = overflow_correction + get_time_tag(d)
                    time_data.append(t)

        else:
            t = overflow_correction + get_time_tag(d)
            time_data.append(t)
            
        
    return time_data



if __name__ == '__main__':
    print("Parse file")

    file_data = read_binary("tttr_data_log.bin")
    t = parse_t2_file(file_data)

    d = np.diff(t)
    time_back_arr = np.where(d < 0)
    print(f' Test if time is going backwards if array is not zero : {time_back_arr}')
    
    assert(time_back_arr)

    plt.plot(t)
    plt.show()
