/*
  Register definitions for slave core: WR switch endpoint controller

  * File           : endpoint_regs.h
  * Author         : auto-generated by wbgen2 from ep_wishbone_controller.wb
  * Created        : Fri Mar 15 17:03:12 2013
  * Standard       : ANSI C

    THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE ep_wishbone_controller.wb
    DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!

*/

#ifndef __WBGEN2_REGDEFS_EP_WISHBONE_CONTROLLER_WB
#define __WBGEN2_REGDEFS_EP_WISHBONE_CONTROLLER_WB

#include <inttypes.h>

#if defined( __GNUC__)
#define PACKED __attribute__ ((packed))
#else
#error "Unsupported compiler?"
#endif

#ifndef __WBGEN2_MACROS_DEFINED__
#define __WBGEN2_MACROS_DEFINED__
#define WBGEN2_GEN_MASK(offset, size) (((1<<(size))-1) << (offset))
#define WBGEN2_GEN_WRITE(value, offset, size) (((value) & ((1<<(size))-1)) << (offset))
#define WBGEN2_GEN_READ(reg, offset, size) (((reg) >> (offset)) & ((1<<(size))-1))
#define WBGEN2_SIGN_EXTEND(value, bits) (((value) & (1<<bits) ? ~((1<<(bits))-1): 0 ) | (value))
#endif


/* definitions for register: Endpoint Control Register */

/* definitions for field: Port identifier in reg: Endpoint Control Register */
#define EP_ECR_PORTID_MASK                    WBGEN2_GEN_MASK(0, 5)
#define EP_ECR_PORTID_SHIFT                   0
#define EP_ECR_PORTID_W(value)                WBGEN2_GEN_WRITE(value, 0, 5)
#define EP_ECR_PORTID_R(reg)                  WBGEN2_GEN_READ(reg, 0, 5)

/* definitions for field: Reset event counters in reg: Endpoint Control Register */
#define EP_ECR_RST_CNT                        WBGEN2_GEN_MASK(5, 1)

/* definitions for field: Transmit path enable in reg: Endpoint Control Register */
#define EP_ECR_TX_EN                          WBGEN2_GEN_MASK(6, 1)

/* definitions for field: Receive path enable in reg: Endpoint Control Register */
#define EP_ECR_RX_EN                          WBGEN2_GEN_MASK(7, 1)

/* definitions for field: Feature present: VLAN tagging in reg: Endpoint Control Register */
#define EP_ECR_FEAT_VLAN                      WBGEN2_GEN_MASK(24, 1)

/* definitions for field: Feature present: DDMTD phase measurement in reg: Endpoint Control Register */
#define EP_ECR_FEAT_DMTD                      WBGEN2_GEN_MASK(25, 1)

/* definitions for field: Feature present: IEEE1588 timestamper in reg: Endpoint Control Register */
#define EP_ECR_FEAT_PTP                       WBGEN2_GEN_MASK(26, 1)

/* definitions for field: Feature present: DPI packet classifier in reg: Endpoint Control Register */
#define EP_ECR_FEAT_DPI                       WBGEN2_GEN_MASK(27, 1)

/* definitions for register: Timestamping Control Register */

/* definitions for field: Transmit timestamping enable in reg: Timestamping Control Register */
#define EP_TSCR_EN_TXTS                       WBGEN2_GEN_MASK(0, 1)

/* definitions for field: Receive timestamping enable in reg: Timestamping Control Register */
#define EP_TSCR_EN_RXTS                       WBGEN2_GEN_MASK(1, 1)

/* definitions for field: Timestamping counter synchronization start in reg: Timestamping Control Register */
#define EP_TSCR_CS_START                      WBGEN2_GEN_MASK(2, 1)

/* definitions for field: Timestamping counter synchronization done in reg: Timestamping Control Register */
#define EP_TSCR_CS_DONE                       WBGEN2_GEN_MASK(3, 1)

/* definitions for field: Start calibration of RX timestamper in reg: Timestamping Control Register */
#define EP_TSCR_RX_CAL_START                  WBGEN2_GEN_MASK(4, 1)

/* definitions for field: RX timestamper calibration result flag in reg: Timestamping Control Register */
#define EP_TSCR_RX_CAL_RESULT                 WBGEN2_GEN_MASK(5, 1)

/* definitions for register: RX Deframer Control Register */

/* definitions for field: RX accept runts in reg: RX Deframer Control Register */
#define EP_RFCR_A_RUNT                        WBGEN2_GEN_MASK(0, 1)

/* definitions for field: RX accept giants in reg: RX Deframer Control Register */
#define EP_RFCR_A_GIANT                       WBGEN2_GEN_MASK(1, 1)

/* definitions for field: RX accept HP in reg: RX Deframer Control Register */
#define EP_RFCR_A_HP                          WBGEN2_GEN_MASK(2, 1)

/* definitions for field: RX keep CRC in reg: RX Deframer Control Register */
#define EP_RFCR_KEEP_CRC                      WBGEN2_GEN_MASK(3, 1)

/* definitions for field: RX Fiter HP Priorities in reg: RX Deframer Control Register */
#define EP_RFCR_HPAP_MASK                     WBGEN2_GEN_MASK(4, 8)
#define EP_RFCR_HPAP_SHIFT                    4
#define EP_RFCR_HPAP_W(value)                 WBGEN2_GEN_WRITE(value, 4, 8)
#define EP_RFCR_HPAP_R(reg)                   WBGEN2_GEN_READ(reg, 4, 8)

/* definitions for field: Maximum receive unit (MRU) in reg: RX Deframer Control Register */
#define EP_RFCR_MRU_MASK                      WBGEN2_GEN_MASK(12, 14)
#define EP_RFCR_MRU_SHIFT                     12
#define EP_RFCR_MRU_W(value)                  WBGEN2_GEN_WRITE(value, 12, 14)
#define EP_RFCR_MRU_R(reg)                    WBGEN2_GEN_READ(reg, 12, 14)

/* definitions for register: VLAN control register 0 */

/* definitions for field: RX 802.1q port mode in reg: VLAN control register 0 */
#define EP_VCR0_QMODE_MASK                    WBGEN2_GEN_MASK(0, 2)
#define EP_VCR0_QMODE_SHIFT                   0
#define EP_VCR0_QMODE_W(value)                WBGEN2_GEN_WRITE(value, 0, 2)
#define EP_VCR0_QMODE_R(reg)                  WBGEN2_GEN_READ(reg, 0, 2)

/* definitions for field: Force 802.1q priority in reg: VLAN control register 0 */
#define EP_VCR0_FIX_PRIO                      WBGEN2_GEN_MASK(2, 1)

/* definitions for field: Port-assigned 802.1q priority in reg: VLAN control register 0 */
#define EP_VCR0_PRIO_VAL_MASK                 WBGEN2_GEN_MASK(4, 3)
#define EP_VCR0_PRIO_VAL_SHIFT                4
#define EP_VCR0_PRIO_VAL_W(value)             WBGEN2_GEN_WRITE(value, 4, 3)
#define EP_VCR0_PRIO_VAL_R(reg)               WBGEN2_GEN_READ(reg, 4, 3)

/* definitions for field: Port-assigned VID in reg: VLAN control register 0 */
#define EP_VCR0_PVID_MASK                     WBGEN2_GEN_MASK(16, 12)
#define EP_VCR0_PVID_SHIFT                    16
#define EP_VCR0_PVID_W(value)                 WBGEN2_GEN_WRITE(value, 16, 12)
#define EP_VCR0_PVID_R(reg)                   WBGEN2_GEN_READ(reg, 16, 12)

/* definitions for register: VLAN Control Register 1 */

/* definitions for field: Egress untagged set bitmap VID in reg: VLAN Control Register 1 */
#define EP_VCR1_VID_MASK                      WBGEN2_GEN_MASK(0, 12)
#define EP_VCR1_VID_SHIFT                     0
#define EP_VCR1_VID_W(value)                  WBGEN2_GEN_WRITE(value, 0, 12)
#define EP_VCR1_VID_R(reg)                    WBGEN2_GEN_READ(reg, 0, 12)

/* definitions for field: Egress untagged set bitmap value in reg: VLAN Control Register 1 */
#define EP_VCR1_VALUE_MASK                    WBGEN2_GEN_MASK(12, 1)
#define EP_VCR1_VALUE_SHIFT                   12
#define EP_VCR1_VALUE_W(value)                WBGEN2_GEN_WRITE(value, 12, 1)
#define EP_VCR1_VALUE_R(reg)                  WBGEN2_GEN_READ(reg, 12, 1)

/* definitions for register: Packet Filter Control Register 0 */

/* definitions for field: Microcode Memory Address in reg: Packet Filter Control Register 0 */
#define EP_PFCR0_MM_ADDR_MASK                 WBGEN2_GEN_MASK(0, 6)
#define EP_PFCR0_MM_ADDR_SHIFT                0
#define EP_PFCR0_MM_ADDR_W(value)             WBGEN2_GEN_WRITE(value, 0, 6)
#define EP_PFCR0_MM_ADDR_R(reg)               WBGEN2_GEN_READ(reg, 0, 6)

/* definitions for field: Microcode Memory Write Enable in reg: Packet Filter Control Register 0 */
#define EP_PFCR0_MM_WRITE_MASK                WBGEN2_GEN_MASK(6, 1)
#define EP_PFCR0_MM_WRITE_SHIFT               6
#define EP_PFCR0_MM_WRITE_W(value)            WBGEN2_GEN_WRITE(value, 6, 1)
#define EP_PFCR0_MM_WRITE_R(reg)              WBGEN2_GEN_READ(reg, 6, 1)

/* definitions for field: Packet Filter Enable in reg: Packet Filter Control Register 0 */
#define EP_PFCR0_ENABLE                       WBGEN2_GEN_MASK(7, 1)

/* definitions for field: Microcode Memory Data (24 MSBs) in reg: Packet Filter Control Register 0 */
#define EP_PFCR0_MM_DATA_MSB_MASK             WBGEN2_GEN_MASK(8, 24)
#define EP_PFCR0_MM_DATA_MSB_SHIFT            8
#define EP_PFCR0_MM_DATA_MSB_W(value)         WBGEN2_GEN_WRITE(value, 8, 24)
#define EP_PFCR0_MM_DATA_MSB_R(reg)           WBGEN2_GEN_READ(reg, 8, 24)

/* definitions for register: Packet Filter Control Register 1 */

/* definitions for field: Microcode Memory Data (12 LSBs) in reg: Packet Filter Control Register 1 */
#define EP_PFCR1_MM_DATA_LSB_MASK             WBGEN2_GEN_MASK(0, 12)
#define EP_PFCR1_MM_DATA_LSB_SHIFT            0
#define EP_PFCR1_MM_DATA_LSB_W(value)         WBGEN2_GEN_WRITE(value, 0, 12)
#define EP_PFCR1_MM_DATA_LSB_R(reg)           WBGEN2_GEN_READ(reg, 0, 12)

/* definitions for register: Traffic Class Assignment Register */

/* definitions for field: 802.1Q priority tag to Traffic Class map in reg: Traffic Class Assignment Register */
#define EP_TCAR_PCP_MAP_MASK                  WBGEN2_GEN_MASK(0, 24)
#define EP_TCAR_PCP_MAP_SHIFT                 0
#define EP_TCAR_PCP_MAP_W(value)              WBGEN2_GEN_WRITE(value, 0, 24)
#define EP_TCAR_PCP_MAP_R(reg)                WBGEN2_GEN_READ(reg, 0, 24)

/* definitions for register: Flow Control Register */

/* definitions for field: RX Pause enable in reg: Flow Control Register */
#define EP_FCR_RXPAUSE                        WBGEN2_GEN_MASK(0, 1)

/* definitions for field: TX Pause enable in reg: Flow Control Register */
#define EP_FCR_TXPAUSE                        WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX pause threshold in reg: Flow Control Register */
#define EP_FCR_TX_THR_MASK                    WBGEN2_GEN_MASK(8, 8)
#define EP_FCR_TX_THR_SHIFT                   8
#define EP_FCR_TX_THR_W(value)                WBGEN2_GEN_WRITE(value, 8, 8)
#define EP_FCR_TX_THR_R(reg)                  WBGEN2_GEN_READ(reg, 8, 8)

/* definitions for field: TX pause quanta in reg: Flow Control Register */
#define EP_FCR_TX_QUANTA_MASK                 WBGEN2_GEN_MASK(16, 16)
#define EP_FCR_TX_QUANTA_SHIFT                16
#define EP_FCR_TX_QUANTA_W(value)             WBGEN2_GEN_WRITE(value, 16, 16)
#define EP_FCR_TX_QUANTA_R(reg)               WBGEN2_GEN_READ(reg, 16, 16)

/* definitions for register: Endpoint MAC address high part register */

/* definitions for register: Endpoint MAC address low part register */

/* definitions for register: MDIO Control Register */

/* definitions for field: MDIO Register Value in reg: MDIO Control Register */
#define EP_MDIO_CR_DATA_MASK                  WBGEN2_GEN_MASK(0, 16)
#define EP_MDIO_CR_DATA_SHIFT                 0
#define EP_MDIO_CR_DATA_W(value)              WBGEN2_GEN_WRITE(value, 0, 16)
#define EP_MDIO_CR_DATA_R(reg)                WBGEN2_GEN_READ(reg, 0, 16)

/* definitions for field: MDIO Register Address in reg: MDIO Control Register */
#define EP_MDIO_CR_ADDR_MASK                  WBGEN2_GEN_MASK(16, 8)
#define EP_MDIO_CR_ADDR_SHIFT                 16
#define EP_MDIO_CR_ADDR_W(value)              WBGEN2_GEN_WRITE(value, 16, 8)
#define EP_MDIO_CR_ADDR_R(reg)                WBGEN2_GEN_READ(reg, 16, 8)

/* definitions for field: MDIO Read/Write select in reg: MDIO Control Register */
#define EP_MDIO_CR_RW                         WBGEN2_GEN_MASK(31, 1)

/* definitions for register: MDIO Address/Status Register */

/* definitions for field: MDIO Read Value in reg: MDIO Address/Status Register */
#define EP_MDIO_ASR_RDATA_MASK                WBGEN2_GEN_MASK(0, 16)
#define EP_MDIO_ASR_RDATA_SHIFT               0
#define EP_MDIO_ASR_RDATA_W(value)            WBGEN2_GEN_WRITE(value, 0, 16)
#define EP_MDIO_ASR_RDATA_R(reg)              WBGEN2_GEN_READ(reg, 0, 16)

/* definitions for field: MDIO PHY Address in reg: MDIO Address/Status Register */
#define EP_MDIO_ASR_PHYAD_MASK                WBGEN2_GEN_MASK(16, 8)
#define EP_MDIO_ASR_PHYAD_SHIFT               16
#define EP_MDIO_ASR_PHYAD_W(value)            WBGEN2_GEN_WRITE(value, 16, 8)
#define EP_MDIO_ASR_PHYAD_R(reg)              WBGEN2_GEN_READ(reg, 16, 8)

/* definitions for field: MDIO Ready in reg: MDIO Address/Status Register */
#define EP_MDIO_ASR_READY                     WBGEN2_GEN_MASK(31, 1)

/* definitions for register: Identification register */

/* definitions for register: Debug/Status register */

/* definitions for field: Link status in reg: Debug/Status register */
#define EP_DSR_LSTATUS                        WBGEN2_GEN_MASK(0, 1)

/* definitions for field: Link activity in reg: Debug/Status register */
#define EP_DSR_LACT                           WBGEN2_GEN_MASK(1, 1)

/* definitions for register: DMTD Control Register */

/* definitions for field: DMTD Phase measurement enable in reg: DMTD Control Register */
#define EP_DMCR_EN                            WBGEN2_GEN_MASK(0, 1)

/* definitions for field: DMTD averaging samples in reg: DMTD Control Register */
#define EP_DMCR_N_AVG_MASK                    WBGEN2_GEN_MASK(16, 12)
#define EP_DMCR_N_AVG_SHIFT                   16
#define EP_DMCR_N_AVG_W(value)                WBGEN2_GEN_WRITE(value, 16, 12)
#define EP_DMCR_N_AVG_R(reg)                  WBGEN2_GEN_READ(reg, 16, 12)

/* definitions for register: DMTD Status register */

/* definitions for field: DMTD Phase shift value in reg: DMTD Status register */
#define EP_DMSR_PS_VAL_MASK                   WBGEN2_GEN_MASK(0, 24)
#define EP_DMSR_PS_VAL_SHIFT                  0
#define EP_DMSR_PS_VAL_W(value)               WBGEN2_GEN_WRITE(value, 0, 24)
#define EP_DMSR_PS_VAL_R(reg)                 WBGEN2_GEN_READ(reg, 0, 24)

/* definitions for field: DMTD Phase shift value ready in reg: DMTD Status register */
#define EP_DMSR_PS_RDY                        WBGEN2_GEN_MASK(24, 1)
/* definitions for RAM: Event counters memory */
#define EP_RMON_RAM_BASE 0x00000080 /* base address */                                
#define EP_RMON_RAM_BYTES 0x00000080 /* size in bytes */                               
#define EP_RMON_RAM_WORDS 0x00000020 /* size in 32-bit words, 32-bit aligned */        

PACKED struct EP_WB {
  /* [0x0]: REG Endpoint Control Register */
  uint32_t ECR;
  /* [0x4]: REG Timestamping Control Register */
  uint32_t TSCR;
  /* [0x8]: REG RX Deframer Control Register */
  uint32_t RFCR;
  /* [0xc]: REG VLAN control register 0 */
  uint32_t VCR0;
  /* [0x10]: REG VLAN Control Register 1 */
  uint32_t VCR1;
  /* [0x14]: REG Packet Filter Control Register 0 */
  uint32_t PFCR0;
  /* [0x18]: REG Packet Filter Control Register 1 */
  uint32_t PFCR1;
  /* [0x1c]: REG Traffic Class Assignment Register */
  uint32_t TCAR;
  /* [0x20]: REG Flow Control Register */
  uint32_t FCR;
  /* [0x24]: REG Endpoint MAC address high part register */
  uint32_t MACH;
  /* [0x28]: REG Endpoint MAC address low part register */
  uint32_t MACL;
  /* [0x2c]: REG MDIO Control Register */
  uint32_t MDIO_CR;
  /* [0x30]: REG MDIO Address/Status Register */
  uint32_t MDIO_ASR;
  /* [0x34]: REG Identification register */
  uint32_t IDCODE;
  /* [0x38]: REG Debug/Status register */
  uint32_t DSR;
  /* [0x3c]: REG DMTD Control Register */
  uint32_t DMCR;
  /* [0x40]: REG DMTD Status register */
  uint32_t DMSR;
  /* padding to: 32 words */
  uint32_t __padding_0[15];
  /* [0x80 - 0xff]: RAM Event counters memory, 32 32-bit words, 32-bit aligned, word-addressable */
  uint32_t RMON_RAM [32];
};

#endif
