/*
  Register definitions for slave core: Mini NIC for WhiteRabbit

  * File           : minic_regs.h
  * Author         : auto-generated by wbgen2 from mini_nic.wb
  * Created        : Thu Oct 27 16:54:11 2016
  * Standard       : ANSI C

    THIS FILE WAS GENERATED BY wbgen2 FROM SOURCE FILE mini_nic.wb
    DO NOT HAND-EDIT UNLESS IT'S ABSOLUTELY NECESSARY!

*/

#ifndef __WBGEN2_REGDEFS_MINI_NIC_WB
#define __WBGEN2_REGDEFS_MINI_NIC_WB

#include <inttypes.h>

#if defined( __GNUC__)
#define PACKED __attribute__ ((packed))
#else
#error "Unsupported compiler?"
#endif

#ifndef __WBGEN2_MACROS_DEFINED__
#define __WBGEN2_MACROS_DEFINED__
#define WBGEN2_GEN_MASK(offset, size) (((1<<(size))-1) << (offset))
#define WBGEN2_GEN_WRITE(value, offset, size) (((value) & ((1<<(size))-1)) << (offset))
#define WBGEN2_GEN_READ(reg, offset, size) (((reg) >> (offset)) & ((1<<(size))-1))
#define WBGEN2_SIGN_EXTEND(value, bits) (((value) & (1<<bits) ? ~((1<<(bits))-1): 0 ) | (value))
#endif


/* definitions for register: miNIC Control Register */

/* definitions for field: TX DMA start in reg: miNIC Control Register */
#define MINIC_MCR_TX_START                    WBGEN2_GEN_MASK(0, 1)

/* definitions for field: TX DMA idle in reg: miNIC Control Register */
#define MINIC_MCR_TX_IDLE                     WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX DMA error in reg: miNIC Control Register */
#define MINIC_MCR_TX_ERROR                    WBGEN2_GEN_MASK(2, 1)

/* definitions for field: TX_FIFO_EMPTY in reg: miNIC Control Register */
#define MINIC_MCR_TX_EMPTY                    WBGEN2_GEN_MASK(3, 1)

/* definitions for field: TX_FIFO_FULL in reg: miNIC Control Register */
#define MINIC_MCR_TX_FULL                     WBGEN2_GEN_MASK(4, 1)

/* definitions for field: RX DMA ready in reg: miNIC Control Register */
#define MINIC_MCR_RX_READY                    WBGEN2_GEN_MASK(8, 1)

/* definitions for field: RX DMA error in reg: miNIC Control Register */
#define MINIC_MCR_RX_ERROR                    WBGEN2_GEN_MASK(9, 1)

/* definitions for field: RX DMA enable in reg: miNIC Control Register */
#define MINIC_MCR_RX_EN                       WBGEN2_GEN_MASK(10, 1)

/* definitions for field: TX TS ready in reg: miNIC Control Register */
#define MINIC_MCR_TX_TS_READY                 WBGEN2_GEN_MASK(11, 1)

/* definitions for field: RX_FIFO_EMPTY in reg: miNIC Control Register */
#define MINIC_MCR_RX_EMPTY                    WBGEN2_GEN_MASK(12, 1)

/* definitions for field: RX_FIFO_FULL in reg: miNIC Control Register */
#define MINIC_MCR_RX_FULL                     WBGEN2_GEN_MASK(13, 1)

/* definitions for field: RX Accepted Packet Classes in reg: miNIC Control Register */
#define MINIC_MCR_RX_CLASS_MASK               WBGEN2_GEN_MASK(16, 8)
#define MINIC_MCR_RX_CLASS_SHIFT              16
#define MINIC_MCR_RX_CLASS_W(value)           WBGEN2_GEN_WRITE(value, 16, 8)
#define MINIC_MCR_RX_CLASS_R(reg)             WBGEN2_GEN_READ(reg, 16, 8)

/* definitions for field: Regs map version in reg: miNIC Control Register */
#define MINIC_MCR_VER_MASK                    WBGEN2_GEN_MASK(24, 4)
#define MINIC_MCR_VER_SHIFT                   24
#define MINIC_MCR_VER_W(value)                WBGEN2_GEN_WRITE(value, 24, 4)
#define MINIC_MCR_VER_R(reg)                  WBGEN2_GEN_READ(reg, 24, 4)

/* definitions for register: TX FIFO Register */

/* definitions for field: Data to send in reg: TX FIFO Register */
#define MINIC_TX_FIFO_DAT_MASK                WBGEN2_GEN_MASK(0, 16)
#define MINIC_TX_FIFO_DAT_SHIFT               0
#define MINIC_TX_FIFO_DAT_W(value)            WBGEN2_GEN_WRITE(value, 0, 16)
#define MINIC_TX_FIFO_DAT_R(reg)              WBGEN2_GEN_READ(reg, 0, 16)

/* definitions for field: Data type in reg: TX FIFO Register */
#define MINIC_TX_FIFO_TYPE_MASK               WBGEN2_GEN_MASK(16, 2)
#define MINIC_TX_FIFO_TYPE_SHIFT              16
#define MINIC_TX_FIFO_TYPE_W(value)           WBGEN2_GEN_WRITE(value, 16, 2)
#define MINIC_TX_FIFO_TYPE_R(reg)             WBGEN2_GEN_READ(reg, 16, 2)

/* definitions for register: RX FIFO Register */

/* definitions for field: Data to send in reg: RX FIFO Register */
#define MINIC_RX_FIFO_DAT_MASK                WBGEN2_GEN_MASK(0, 16)
#define MINIC_RX_FIFO_DAT_SHIFT               0
#define MINIC_RX_FIFO_DAT_W(value)            WBGEN2_GEN_WRITE(value, 0, 16)
#define MINIC_RX_FIFO_DAT_R(reg)              WBGEN2_GEN_READ(reg, 0, 16)

/* definitions for field: Data type in reg: RX FIFO Register */
#define MINIC_RX_FIFO_TYPE_MASK               WBGEN2_GEN_MASK(16, 2)
#define MINIC_RX_FIFO_TYPE_SHIFT              16
#define MINIC_RX_FIFO_TYPE_W(value)           WBGEN2_GEN_WRITE(value, 16, 2)
#define MINIC_RX_FIFO_TYPE_R(reg)             WBGEN2_GEN_READ(reg, 16, 2)

/* definitions for field: RX_FIFO_EMPTY in reg: RX FIFO Register */
#define MINIC_RX_FIFO_EMPTY                   WBGEN2_GEN_MASK(30, 1)

/* definitions for field: RX_FIFO_FULL in reg: RX FIFO Register */
#define MINIC_RX_FIFO_FULL                    WBGEN2_GEN_MASK(31, 1)

/* definitions for register: TX timestamp register 0 */

/* definitions for field: Timestamp valid in reg: TX timestamp register 0 */
#define MINIC_TSR0_VALID                      WBGEN2_GEN_MASK(0, 1)

/* definitions for field: Port ID in reg: TX timestamp register 0 */
#define MINIC_TSR0_PID_MASK                   WBGEN2_GEN_MASK(1, 5)
#define MINIC_TSR0_PID_SHIFT                  1
#define MINIC_TSR0_PID_W(value)               WBGEN2_GEN_WRITE(value, 1, 5)
#define MINIC_TSR0_PID_R(reg)                 WBGEN2_GEN_READ(reg, 1, 5)

/* definitions for field: Frame ID in reg: TX timestamp register 0 */
#define MINIC_TSR0_FID_MASK                   WBGEN2_GEN_MASK(6, 16)
#define MINIC_TSR0_FID_SHIFT                  6
#define MINIC_TSR0_FID_W(value)               WBGEN2_GEN_WRITE(value, 6, 16)
#define MINIC_TSR0_FID_R(reg)                 WBGEN2_GEN_READ(reg, 6, 16)

/* definitions for register: TX timestamp register 1 */

/* definitions for field: Timestamp value in reg: TX timestamp register 1 */
#define MINIC_TSR1_TSVAL_MASK                 WBGEN2_GEN_MASK(0, 32)
#define MINIC_TSR1_TSVAL_SHIFT                0
#define MINIC_TSR1_TSVAL_W(value)             WBGEN2_GEN_WRITE(value, 0, 32)
#define MINIC_TSR1_TSVAL_R(reg)               WBGEN2_GEN_READ(reg, 0, 32)

/* definitions for register: Debug register */

/* definitions for field: interrupt counter in reg: Debug register */
#define MINIC_DBGR_IRQ_CNT_MASK               WBGEN2_GEN_MASK(0, 24)
#define MINIC_DBGR_IRQ_CNT_SHIFT              0
#define MINIC_DBGR_IRQ_CNT_W(value)           WBGEN2_GEN_WRITE(value, 0, 24)
#define MINIC_DBGR_IRQ_CNT_R(reg)             WBGEN2_GEN_READ(reg, 0, 24)

/* definitions for field: status of wb_irq_o line in reg: Debug register */
#define MINIC_DBGR_WB_IRQ_VAL                 WBGEN2_GEN_MASK(24, 1)

/* definitions for register: Memory protection reg */

/* definitions for field: address range lo in reg: Memory protection reg */
#define MINIC_MPROT_LO_MASK                   WBGEN2_GEN_MASK(0, 16)
#define MINIC_MPROT_LO_SHIFT                  0
#define MINIC_MPROT_LO_W(value)               WBGEN2_GEN_WRITE(value, 0, 16)
#define MINIC_MPROT_LO_R(reg)                 WBGEN2_GEN_READ(reg, 0, 16)

/* definitions for field: address range hi in reg: Memory protection reg */
#define MINIC_MPROT_HI_MASK                   WBGEN2_GEN_MASK(16, 16)
#define MINIC_MPROT_HI_SHIFT                  16
#define MINIC_MPROT_HI_W(value)               WBGEN2_GEN_WRITE(value, 16, 16)
#define MINIC_MPROT_HI_R(reg)                 WBGEN2_GEN_READ(reg, 16, 16)

/* definitions for register: Interrupt disable register */

/* definitions for field: TX DMA interrupt in reg: Interrupt disable register */
#define MINIC_EIC_IDR_TX                      WBGEN2_GEN_MASK(0, 1)

/* definitions for field: RX DMA interrupt in reg: Interrupt disable register */
#define MINIC_EIC_IDR_RX                      WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX timestamp available in reg: Interrupt disable register */
#define MINIC_EIC_IDR_TXTS                    WBGEN2_GEN_MASK(2, 1)

/* definitions for register: Interrupt enable register */

/* definitions for field: TX DMA interrupt in reg: Interrupt enable register */
#define MINIC_EIC_IER_TX                      WBGEN2_GEN_MASK(0, 1)

/* definitions for field: RX DMA interrupt in reg: Interrupt enable register */
#define MINIC_EIC_IER_RX                      WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX timestamp available in reg: Interrupt enable register */
#define MINIC_EIC_IER_TXTS                    WBGEN2_GEN_MASK(2, 1)

/* definitions for register: Interrupt mask register */

/* definitions for field: TX DMA interrupt in reg: Interrupt mask register */
#define MINIC_EIC_IMR_TX                      WBGEN2_GEN_MASK(0, 1)

/* definitions for field: RX DMA interrupt in reg: Interrupt mask register */
#define MINIC_EIC_IMR_RX                      WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX timestamp available in reg: Interrupt mask register */
#define MINIC_EIC_IMR_TXTS                    WBGEN2_GEN_MASK(2, 1)

/* definitions for register: Interrupt status register */

/* definitions for field: TX DMA interrupt in reg: Interrupt status register */
#define MINIC_EIC_ISR_TX                      WBGEN2_GEN_MASK(0, 1)

/* definitions for field: RX DMA interrupt in reg: Interrupt status register */
#define MINIC_EIC_ISR_RX                      WBGEN2_GEN_MASK(1, 1)

/* definitions for field: TX timestamp available in reg: Interrupt status register */
#define MINIC_EIC_ISR_TXTS                    WBGEN2_GEN_MASK(2, 1)
/* [0x0]: REG miNIC Control Register */
#define MINIC_REG_MCR 0x00000000
/* [0x4]: REG TX FIFO Register */
#define MINIC_REG_TX_FIFO 0x00000004
/* [0x8]: REG RX FIFO Register */
#define MINIC_REG_RX_FIFO 0x00000008
/* [0xc]: REG reserved 1 */
#define MINIC_REG_RESV_1 0x0000000c
/* [0x10]: REG reserved 2 */
#define MINIC_REG_RESV_2 0x00000010
/* [0x14]: REG TX timestamp register 0 */
#define MINIC_REG_TSR0 0x00000014
/* [0x18]: REG TX timestamp register 1 */
#define MINIC_REG_TSR1 0x00000018
/* [0x1c]: REG Debug register */
#define MINIC_REG_DBGR 0x0000001c
/* [0x20]: REG Memory protection reg */
#define MINIC_REG_MPROT 0x00000020
/* [0x40]: REG Interrupt disable register */
#define MINIC_REG_EIC_IDR 0x00000040
/* [0x44]: REG Interrupt enable register */
#define MINIC_REG_EIC_IER 0x00000044
/* [0x48]: REG Interrupt mask register */
#define MINIC_REG_EIC_IMR 0x00000048
/* [0x4c]: REG Interrupt status register */
#define MINIC_REG_EIC_ISR 0x0000004c
#endif
