
/* 
    PH330Lib programming library for PicoHarp 330
    PicoQuant GmbH 

    Ver. 2.0.0.0  August 2024
*/

// Note: The constants below are fixed and hard coded in the binaries.
// Changing them here is pointless, don't do it, do not edit this file.

#define LIB_VERSION "2.0"   // library version

#define MAXDEVNUM   8       // max number of USB devices
 
#define MAXINPCHAN  4       // max number of physical input channels

#define MAXBINSTEPS 24      // max number of binning steps, 
                            // get actual number via PH330_GetBaseResolution()

#define MAXHISTLEN  524288  // max number of histogram bins
#define DFLTHISTLEN  65536  // default number of histogram bins

#define TTREADMAX  1048576  // number of event records that can be read by PH330_ReadFiFo
                            // buffer must provide space for this number of dwords

//symbolic constants for PH330_Initialize parameter "refsource"
#define REFSRC_INTERNAL          0   // use internal clock
#define REFSRC_EXTERNAL_10MHZ    1   // use 10MHz external clock
#define REFSRC_EXTERNAL_100MHZ   2   // use 100MHz external clock
#define REFSRC_EXTERNAL_500MHZ   3   // use 500MHz external clock

//symbolic constants for PH330_Initialize parameter "mode"
#define MODE_HIST       0
#define MODE_T2         2
#define MODE_T3         3

//symbolic constants for PH330_SetMeasControl parameter "control"
#define MEASCTRL_SINGLESHOT_CTC            0 //default
#define MEASCTRL_C1_GATED                  1
#define MEASCTRL_C1_START_CTC_STOP         2
#define MEASCTRL_C1_START_C2_STOP          3
#define MEASCTRL_SW_START_SW_STOP          6

//codes for PH330_SetMeasControl, PH330_SetMarkerEdges, PH330_SetSyncEdgeTrg and PH330_SetInputEdgeTrg parameters "..edge"
#define EDGE_RISING   1
#define EDGE_FALLING  0

//limits for PH330_SetHistoLen
#define MINLENCODE  0      // 1024 channels
#define MAXLENCODE  9      // 524288 channels
#define DFLTLENCODE 6      // 65536 channels, default, see DFLTHISTLEN

//limits for PH330_SetSyncDiv
#define SYNCDIVMIN          1
#define SYNCDIVMAX          8

//codes for PH330_SetSyncTrgMode and PH330_SetInputTrgMode parameter "mode"
#define TRGMODE_ETR         0     // edge trigger
#define TRGMODE_CFD         1     // constant fraction discriminator

//limits for PH330_SetSyncEdgeTrg and PH330_SetInputEdgeTrg
#define TRGLVLMIN       -1500     // mV
#define TRGLVLMAX        1500     // mV

//limits for PH330_SetSyncCFD and PH330_SetInputCFD
#define CFDLVLMIN       -1500     // mV
#define CFDLVLMAX           0     // mV
#define CFDZCMIN         -100     // mV
#define CFDZCMAX            0     // mV

//limits for PH330_SetSyncChannelOffset and PH330_SetInputChannelOffset
#define CHANOFFSMIN    -99999     // ps
#define CHANOFFSMAX     99999     // ps

//limits for PH330_SetSyncDeadTime and PH330_SetInputDeadTime
#define EXTDEADMIN        800     // ps
#define EXTDEADMAX     160000     // ps

//limits for PH330_SetOffset
#define OFFSETMIN           0     // ns
#define OFFSETMAX   100000000     // ns

//limits for PH330_StartMeas
#define ACQTMIN             1     // ms
#define ACQTMAX     360000000     // ms  (100*60*60*1000ms = 100h)

//limits for PH330_SetStopOverflow
#define STOPCNTMIN          1
#define STOPCNTMAX 4294967295     // 32 bit is mem max

//limits for PH330_SetTriggerOutput
#define TRIGOUTMIN          0	  // 0=off
#define TRIGOUTMAX   16777215     // in units of 100ns

//limits for PH330_SetMarkerHoldoffTime
#define HOLDOFFMIN          0     // ns
#define HOLDOFFMAX      25500     // ns

//limits for PH330_SetInputHysteresis
#define HYSTCODEMIN         0     // approx. 3mV
#define HYSTCODEMAX         1     // approx. 35mV

//limits for PH330_SetOflCompression
#define HOLDTIMEMIN         0     // ms
#define HOLDTIMEMAX       255     // ms

//limits for PH330_SetEventFilterParams and PH330_SetEventFilterChannels
#define MATCHCNTMIN         1     
#define MATCHCNTMAX         6 
#define INVERSEMIN          0
#define INVERSEMAX          1
#define TIMERANGEMIN        0     // ps
#define TIMERANGEMAX   160000     // ps
#define USECHANSMIN     0x000     // no channels used 
#define USECHANSMAX     0x10F     // note: sync bit 0x100 will be ignored in T3 mode
#define PASSCHANSMIN    0x000     // no channels passed 
#define PASSCHANSMAX    0x10F     // note: sync bit 0x100 will be ignored in T3 mode

//bitmasks for results from PH330_GetFeatures
#define FEATURE_DLL       0x0001  // DLL License available
#define FEATURE_TTTR      0x0002  // TTTR mode available
#define FEATURE_MARKERS   0x0004  // Markers available
#define FEATURE_LOWRES    0x0008  // Long range mode available 
#define FEATURE_TRIGOUT   0x0010  // Trigger output available
#define FEATURE_PROG_TD   0x0020  // Programmable deadtime available
#define FEATURE_EXT_FPGA  0x0040  // Interface for external FPGA available
#define FEATURE_PROG_HYST 0x0080  // Programmable input hysteresis available
#define FEATURE_EVNT_FILT 0x0100  // Coincidence filtering available
#define FEATURE_INPT_MODE 0x0200  // Programmable input mode (CFD vs. edge trigger)

//bitmasks for results from PH330_GetFlags
#define FLAG_OVERFLOW     0x0001  // histo mode only
#define FLAG_FIFOFULL     0x0002  // TTTR mode only
#define FLAG_SYNC_LOST    0x0004  
#define FLAG_REF_LOST     0x0008  
#define FLAG_SYSERROR     0x0010  // hardware error, must contact support
#define FLAG_ACTIVE       0x0020  // measurement is running
#define FLAG_CNTS_DROPPED 0x0040  // counts were dropped
#define FLAG_SOFTERROR    0x0080  // software error, must contact support

//bitmasks for results from PH330_GetWarnings
#define WARNING_SYNC_RATE_ZERO			0x0001
#define WARNING_SYNC_RATE_VERY_LOW		0x0002
#define WARNING_SYNC_RATE_TOO_HIGH		0x0004
#define WARNING_INPT_RATE_ZERO			0x0010
#define WARNING_INPT_RATE_TOO_HIGH		0x0040
#define WARNING_INPT_RATE_RATIO			0x0100
#define WARNING_DIVIDER_GREATER_ONE		0x0200
#define WARNING_TIME_SPAN_TOO_SMALL		0x0400
#define WARNING_OFFSET_UNNECESSARY		0x0800
#define WARNING_DIVIDER_TOO_SMALL		0x1000
#define WARNING_COUNTS_DROPPED			0x2000
#define WARNING_USB20_SPEED_ONLY		0x4000
