# Setup
The following part describes to do the basic setup of your first rust project using the PH330. If you are not familiar with rust, it is highly recommended
to read the **rust book** https://doc.rust-lang.org/book/ as well as getting started with cargo, the rust package manager https://doc.rust-lang.org/cargo/

## Install
Follow the steps from https://www.rust-lang.org/tools/install


## Structure
root
├──src
│   ├── main.rs          # A very basic demonstration on how to use the PH330 with Rust
│   ├── PH330.rs         # wrapper to convert C to rust
│   └── errorcodes.rs    # Definition of error codes that will be returned by every function in case of malfunction
│
├── build.rs 	         # Build script, necessary for linking etc.
├── Cargo.toml           # describe your dependencies here, like adding the package with version bytemuck = "1.7.0"
├── Cargo.lock           # DO NOT EDIT, contains exact information about dependencies. It is maintained by Cargo only!
├── PH330.dll            # C Dll, will be used by the linker and executable
└── PH330.lib            # C lib, will be used by the linker and executable

## Build
To build the rust code use the following command
'''
cargo build
'''


## Run
To run the compiled code use the following command
'''
cargo run
'''

For more information, please visit https://doc.rust-lang.org/cargo/

# Debug and development
For debugging and future development we recommend the IDE Visual Studio code + the rust-analyzer extension
