use std::convert::TryFrom;

#[derive(Debug, PartialEq, Eq)]
pub enum ErrorCode {
    None,
    DeviceOpenFail,
    DeviceBusy,
    DeviceHEventFail,
    DeviceCallbsetFail,
    DeviceBarmapFail,
    DeviceCloseFail,
    DeviceResetFail,
    DeviceGetVersionFail,
    DeviceVersionMismatch,
    DeviceNotOpen,
    DeviceLocked,
    DeviceDriverVerMismatch,
    InstanceRunning,
    InvalidArgument,
    InvalidMode,
    InvalidOption,
    InvalidMemory,
    InvalidRData,
    NotInitialized,
    NotCalibrated,
    DmaFail,
    XtDeviceFail,
    FpgaConfFail,
    IfConfFail,
    FifoResetFail,
    ThreadStateFail,
    ThreadLockFail,
    UsbGetDriverVerFail,
    UsbDriverVerMismatch,
    UsbGetIfInfoFail,
    UsbHiSpeedFail,
    UsbVcmdFail,
    UsbBulkRdFail,
    UsbResetFail,
    LaneUpTimeout,
    DoneAllTimeout,
    MbAckTimeout,
    MActiveTimeout,
    MemClearFail,
    MemTestFail,
    CalibFail,
    RefSelFail,
    StatusFail,
    ModNumFail,
    DigMuxFail,
    ModMuxFail,
    ModFwPcbMismatch,
    ModFwVerMismatch,
    ModPropertyMismatch,
    InvalidMagic,
    InvalidLength,
    RateFail,
    ModFwVerTooLow,
    ModFwVerTooHigh,
    MbAckFail,
    EepromF01,
    EepromF02,
    EepromF03,
    EepromF04,
    EepromF05,
    EepromF06,
    EepromF07,
    EepromF08,
    EepromF09,
    EepromF10,
    EepromF11,
    EepromF12,
    EepromF13,
    EepromF14,
    EepromF15,
    UnsupportedFunction,
    WrongTrgMode,
    BulkRdInitFail,
    CreateThreadFail,
    InvalidArgument1,
    InvalidArgument2,
    InvalidArgument3,
    InvalidArgument4,
    InvalidArgument5,
    InvalidArgument6,
    InvalidArgument7,
    InvalidArgument8,
}

impl TryFrom<i32> for ErrorCode {
    type Error = ();

    fn try_from(value: i32) -> Result<Self, Self::Error> {
        match value {
            0 => Ok(ErrorCode::None),
            -1 => Ok(ErrorCode::DeviceOpenFail),
            -2 => Ok(ErrorCode::DeviceBusy),
            -3 => Ok(ErrorCode::DeviceHEventFail),
            -4 => Ok(ErrorCode::DeviceCallbsetFail),
            -5 => Ok(ErrorCode::DeviceBarmapFail),
            -6 => Ok(ErrorCode::DeviceCloseFail),
            -7 => Ok(ErrorCode::DeviceResetFail),
            -8 => Ok(ErrorCode::DeviceGetVersionFail),
            -9 => Ok(ErrorCode::DeviceVersionMismatch),
            -10 => Ok(ErrorCode::DeviceNotOpen),
            -11 => Ok(ErrorCode::DeviceLocked),
            -12 => Ok(ErrorCode::DeviceDriverVerMismatch),
            -16 => Ok(ErrorCode::InstanceRunning),
            -17 => Ok(ErrorCode::InvalidArgument),
            -18 => Ok(ErrorCode::InvalidMode),
            -19 => Ok(ErrorCode::InvalidOption),
            -20 => Ok(ErrorCode::InvalidMemory),
            -21 => Ok(ErrorCode::InvalidRData),
            -22 => Ok(ErrorCode::NotInitialized),
            -23 => Ok(ErrorCode::NotCalibrated),
            -24 => Ok(ErrorCode::DmaFail),
            -25 => Ok(ErrorCode::XtDeviceFail),
            -26 => Ok(ErrorCode::FpgaConfFail),
            -27 => Ok(ErrorCode::IfConfFail),
            -28 => Ok(ErrorCode::FifoResetFail),
            -29 => Ok(ErrorCode::ThreadStateFail),
            -30 => Ok(ErrorCode::ThreadLockFail),
            -32 => Ok(ErrorCode::UsbGetDriverVerFail),
            -33 => Ok(ErrorCode::UsbDriverVerMismatch),
            -34 => Ok(ErrorCode::UsbGetIfInfoFail),
            -35 => Ok(ErrorCode::UsbHiSpeedFail),
            -36 => Ok(ErrorCode::UsbVcmdFail),
            -37 => Ok(ErrorCode::UsbBulkRdFail),
            -38 => Ok(ErrorCode::UsbResetFail),
            -40 => Ok(ErrorCode::LaneUpTimeout),
            -41 => Ok(ErrorCode::DoneAllTimeout),
            -42 => Ok(ErrorCode::MbAckTimeout),
            -43 => Ok(ErrorCode::MActiveTimeout),
            -44 => Ok(ErrorCode::MemClearFail),
            -45 => Ok(ErrorCode::MemTestFail),
            -46 => Ok(ErrorCode::CalibFail),
            -47 => Ok(ErrorCode::RefSelFail),
            -48 => Ok(ErrorCode::StatusFail),
            -49 => Ok(ErrorCode::ModNumFail),
            -50 => Ok(ErrorCode::DigMuxFail),
            -51 => Ok(ErrorCode::ModMuxFail),
            -52 => Ok(ErrorCode::ModFwPcbMismatch),
            -53 => Ok(ErrorCode::ModFwVerMismatch),
            -54 => Ok(ErrorCode::ModPropertyMismatch),
            -55 => Ok(ErrorCode::InvalidMagic),
            -56 => Ok(ErrorCode::InvalidLength),
            -57 => Ok(ErrorCode::RateFail),
            -58 => Ok(ErrorCode::ModFwVerTooLow),
            -59 => Ok(ErrorCode::ModFwVerTooHigh),
            -60 => Ok(ErrorCode::MbAckFail),
            -64 => Ok(ErrorCode::EepromF01),
            -65 => Ok(ErrorCode::EepromF02),
            -66 => Ok(ErrorCode::EepromF03),
            -67 => Ok(ErrorCode::EepromF04),
            -68 => Ok(ErrorCode::EepromF05),
            -69 => Ok(ErrorCode::EepromF06),
            -70 => Ok(ErrorCode::EepromF07),
            -71 => Ok(ErrorCode::EepromF08),
            -72 => Ok(ErrorCode::EepromF09),
            -73 => Ok(ErrorCode::EepromF10),
            -74 => Ok(ErrorCode::EepromF11),
            -75 => Ok(ErrorCode::EepromF12),
            -76 => Ok(ErrorCode::EepromF13),
            -77 => Ok(ErrorCode::EepromF14),
            -78 => Ok(ErrorCode::EepromF15),
            -80 => Ok(ErrorCode::UnsupportedFunction),
            -81 => Ok(ErrorCode::WrongTrgMode),
            -82 => Ok(ErrorCode::BulkRdInitFail),
            -83 => Ok(ErrorCode::CreateThreadFail),
            -201 => Ok(ErrorCode::InvalidArgument1),
            -202 => Ok(ErrorCode::InvalidArgument2),
            -203 => Ok(ErrorCode::InvalidArgument3),
            -204 => Ok(ErrorCode::InvalidArgument4),
            -205 => Ok(ErrorCode::InvalidArgument5),
            -206 => Ok(ErrorCode::InvalidArgument6),
            -207 => Ok(ErrorCode::InvalidArgument7),
            -208 => Ok(ErrorCode::InvalidArgument8),
            _ => Err(()),
        }
    }
}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn it_works() {
        assert!(true)
    }
    #[test]
    fn convert_42() {
        assert_eq!(ErrorCode::MbAckTimeout, ErrorCode::try_from(-42).unwrap());
    }
}
